<?php echo $__env->make('header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

       <!--start content-->
       <main class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
          <div class="breadcrumb-title pe-3">Dashboard</div>
          <div class="ps-3">
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb mb-0 p-0">
                <li class="breadcrumb-item"><a href="javascript:;"><i class="bx bx-home-alt"></i></a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Payroll</li>
              </ol>
            </nav>
          </div>


          
        </div>
        <!--end breadcrumb-->

           <div class="card">
             <div class="card-body">
               <div class="d-flex align-items-center">
                  <h5 class="mb-0">Payroll</h5>
                   <form class="ms-auto position-relative">
                     <div class="position-absolute top-50 translate-middle-y search-icon px-3"><i class="bi bi-search"></i></div>
                     <input class="form-control ps-5" type="text" placeholder="search">
                   </form>
               </div>
              <form class="ms-auto" id="addForm" action="add_payroll" method="post">
                <?php echo csrf_field(); ?>
                <div class="btn-group">
                  <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#exampleVerticallycenteredModal">Add to Payroll</button>             
                  <a href="<?php echo e(route('export.payroll')); ?>" class="btn btn-success">Export Payroll to CSV</a>
                  <div class="modal fade" id="exampleVerticallycenteredModal" tabindex="-1" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered">
                      <div class="modal-content">
                        <div class="modal-header border border-0">
                          <h5 class="modal-title">Add Payroll</h5>
                          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">

                          <div class="col-md-12 mb-3">
                            <label for="validationDefault01" class="form-label">Employee name</label>
                            <select class="form-control" id="employee_list" name="employee_id">
                                <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($employee->id); ?>"><?php echo e($employee->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                          </div>

                          
                          <div class="col-md-12 mb-3">
                            <label for="validationDefault01" class="form-label">Bank Name</label>
                            <input type="text" name="bank_name" class="form-control" value="" required>
                          </div>
                          <div class="col-md-12 mb-3">
                            <label for="validationDefault01" class="form-label">Account Name</label>
                            <input type="text" name="account_name" class="form-control" value="" required>
                          </div>
                          <div class="col-md-12 mb-3">
                            <label for="validationDefault01" class="form-label">Account No</label>
                            <input type="text" name="account_no" class="form-control" value="" required>
                          </div>
                          <div class="col-md-12 mb-3">
                            <label for="validationDefault01" class="form-label">Salary</label>
                            <input type="text" name="salary" class="form-control" value="" required>
                          </div>
                          <div class="col-md-12 mb-3">
                            <label for="validationDefault01" class="form-label">Status</label>
                            <select name="status" id="status" class="form-control">
                              <option>Active</option>
                              <option>In Active</option>
                            </select>
                          </div>
                          
                          

                        </div>
                        <div class="modal-footer border border-0">
                          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                          <button type="submit" data-bs-dismiss="modal" class="btn btn-primary">Save changes</button>
                        </div>
                      </div>
                    </div>
                  </div>
                </div> 
              </form>


               <div class="table-responsive mt-3">
                 <table class="table align-middle">
                   <thead class="table-secondary">
                     <tr>
                      <th>#</th>
                      <th>Name</th>
                      <!-- <th>Phone</th>
                      <th>Position</th> -->
                      <th>Bank Name</th>
                      <th>Account Name</th>
                      <th>Account No</th>
                      <th>Actual Salary</th>
                      <th>Paid Salary</th>
                      <th>Deduction</th>
                      <th>Status</th>
                      <th>Actions</th>
                     </tr>
                   </thead>
                   <tbody id="tableBody">
                      <?php $__currentLoopData = $payroll; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pay): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <tr>
                            <td>#</td>
                            <td><?php echo e($pay->employee->name); ?></td>
                            <td><?php echo e($pay->bank_name); ?></td>
                            <td><?php echo e($pay->account_name); ?></td>
                            <td><?php echo e($pay->account_no); ?></td>
                            <td><?php echo e($pay->salary); ?></td>
                            <td><?php echo e($pay->paid_salary); ?></td>
                            <td><?php echo e($pay->deduction); ?></td>
                            <td><?php echo e($pay->status); ?></td>
                            <td>
                                    <a class="text-primary" data-bs-toggle="modal" data-bs-target="#updateModal<?php echo e($pay->id); ?>" title="Edit">
                                        <i class="bi bi-pencil-fill"></i>
                                    </a>
                                    <div class="modal fade" id="updateModal<?php echo e($pay->id); ?>" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <form action="update_supplier" class="modal-content" method="post">
                                              <?php echo csrf_field(); ?>
                                                <div class="modal-header border border-0">
                                                    <h5 class="modal-title">Update Payroll</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <input type="hidden" name="id" value="<?php echo e($pay->id); ?>">

                                                    <div class="col-md-12 mb-3">
                                                      <label for="validationDefault01" class="form-label">Bank Name</label>
                                                      <input type="text" name="bank_name" class="form-control" value="<?php echo e($pay->bank_name); ?>" required>
                                                    </div>
                                                    <div class="col-md-12 mb-3">
                                                      <label for="validationDefault01" class="form-label">Account Name</label>
                                                      <input type="text" name="account_name" class="form-control" value="<?php echo e($pay->account_name); ?>" required>
                                                    </div>
                                                    <div class="col-md-12 mb-3">
                                                      <label for="validationDefault01" class="form-label">Account No</label>
                                                      <input type="text" name="account_no" class="form-control" value="<?php echo e($pay->account_no); ?>" required>
                                                    </div>
                                                    <div class="col-md-12 mb-3">
                                                      <label for="validationDefault01" class="form-label">Salary</label>
                                                      <input type="text" name="salary" class="form-control" value="<?php echo e($pay->salary); ?>" required>
                                                    </div>
                                                    <div class="col-md-12 mb-3">
                                                      <label for="validationDefault01" class="form-label">Status</label>
                                                      <select name="status" id="status" class="form-control">
                                                        <option value="<?php echo e($pay->status); ?>"><?php echo e($pay->status); ?></option>
                                                        <option>Active</option>
                                                        <option>In Active</option>
                                                      </select>
                                                    </div>
                                                </div>
                                                <div class="modal-footer border border-0">
                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                                    <button type="submit" class="btn btn-primary">
                                                        Save changes
                                                    </button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>

                                    <a href="delete_supplier/<?php echo e($pay->id); ?>" class="text-danger">
                                        <i class="bi bi-trash-fill"></i>
                                    </a>                              
                            </td>
                          </tr>

                     <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                   </tbody>
                 </table>

               </div>
             </div>
           </div>

       </main>
       <!--end page main-->
<?php echo $__env->make('footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\factory_v2\resources\views/payroll.blade.php ENDPATH**/ ?>