<?php echo $__env->make('header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

       <!--start content-->
       <main class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
          <div class="breadcrumb-title pe-3">Dashboard</div>
          <div class="ps-3">
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb mb-0 p-0">
                <li class="breadcrumb-item"><a href="javascript:;"><i class="bx bx-home-alt"></i></a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Expenses</li>
              </ol>
            </nav>
          </div>

          
        </div>
        <!--end breadcrumb-->

           <div class="card">
             <div class="card-body">
               <div class="d-flex align-items-center">
                  <h5 class="mb-0">Expense Details</h5>
                   <form class="ms-auto position-relative">
                     <div class="position-absolute top-50 translate-middle-y search-icon px-3"><i class="bi bi-search"></i></div>
                     <input class="form-control ps-5" type="text" placeholder="search">
                   </form>
               </div>
                <form class="ms-auto" id="addForm" method="post" action="add_expense">
                  <?php echo csrf_field(); ?>
                  <div class="btn-group">
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#exampleVerticallycenteredModal">Add Expense</button>

                    
                    <div class="modal fade" id="exampleVerticallycenteredModal" tabindex="-1" aria-hidden="true">
                      <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content">
                          <div class="modal-header border border-0">
                            <h5 class="modal-title">Add Expenses</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                          </div>
                          <div class="modal-body">


                            <div class="col-md-12 mb-3">
                              <label for="validationDefault01" class="form-label">Supplier's name</label>
                              <select class="form-control" id="supplier_list">
                                
                              </select>
                              <div class="accordion" id="accordionExample">
                                <div class="accordion-item p-0">
                                  <div class="accordion-header" id="headingThree">
                                    <button class="accordion-button p-2 collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                                      Add Supplier
                                    </button>
                                  </div>
                                  <div id="collapseThree" class="accordion-collapse collapse" aria-labelledby="headingThree" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                      <div class="row">
                                        <div class="col-md-6">
                                          <label for="validationDefault01" class="form-label">Full name</label>
                                          <input type="text" id="new_name" class="form-control" id="validationDefault02" value="" required>
                                        </div>
                                        <div class="col-md-6">
                                          <label for="validationDefault01" class="form-label">Email</label>
                                          <input type="text" id="new_email" class="form-control" id="validationDefault02" value="" required>
                                        </div>
                                      </div>
                                      <div class="row">
                                        <div class="col-md-6">
                                          <label for="validationDefault01" class="form-label">Phone</label>
                                          <input type="text" id="new_phone" class="form-control" id="validationDefault02" value="" required>
                                        </div>
                  
                                        <div class="col-md-6">
                                          <label for="validationDefault01" class="form-label">Address</label>
                                          <input type="text" id="new_address" class="form-control" id="validationDefault02" value="" required>
                                        </div>
                                      </div>

                                      <div class="col-12 mt-2">
                                        <button type="button" data-bs-dismiss="modal" class="btn btn-primary btn-sm" id="addSupplierButton">
                                          Add Supplier
                                        </button>
                                      </div>
                                      
                                    </div>
                                  </div>
                                </div>
                              </div>
                            </div>
                            

                            <div class="col-md-12 mb-3">
                              <label for="validationDefault01" class="form-label">Material name</label>
                              <select class="form-control" id="material_list">
                                
                              </select>
                              <div class="accordion" id="accordionExample">
                                <div class="accordion-item p-0">
                                  <div class="accordion-header" id="headingThree">
                                    <button class="accordion-button p-2 collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                                      Add Material
                                    </button>
                                  </div>
                                  <div id="collapseFour" class="accordion-collapse collapse" aria-labelledby="headingThree" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                      <div class="row">
                                        <div class="col-md-6">
                                          <label for="validationDefault01" class="form-label">Material name</label>
                                          <input type="text" id="material_name" class="form-control">
                                        </div>
                                        <div class="col-md-6">
                                          <label for="validationDefault02" class="form-label">Quantity</label>
                                          <input type="number" id="material_quantity" class="form-control">
                                        </div>
                                      </div>
                                      

                                      <div class="col-12 mt-2">
                                        <button type="button" data-bs-dismiss="modal" class="btn btn-primary btn-sm" id="addMaterialButton">
                                          Add Material
                                        </button>
                                      </div>
                                      
                                    </div>
                                  </div>
                                </div>
                              </div>
                            </div>
                            <div class="col-md-12 mb-3">
                              <label for="validationDefault02" class="form-label">Quantity</label>
                              <input type="number" id="quantity" class="form-control" id="validationDefault02" required>
                            </div>

                            <div class="col-md-12 mb-3">
                              <label for="validationDefault02" class="form-label">Price</label>
                              <input type="number" id="price" class="form-control" id="validationDefault02"  required>
                            </div>

                            <div class="col-md-12 mb-3">
                              <label for="validationDefault02" class="form-label">Amount</label>
                              <input type="number" id="amount" class="form-control" id="validationDefault02"  required>
                            </div>

                            <div class="col-md-12 mb-3">
                              <label for="validationDefault02" class="form-label">Paid</label>
                              <input type="number" id="paid" class="form-control" id="validationDefault02" required>
                            </div>

                          </div>
                          <div class="modal-footer border border-0">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                            <button type="submit" data-bs-dismiss="modal" class="btn btn-primary">Save changes</button>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </form>
               <div class="table-responsive mt-3">
                 <table class="table align-middle">
                   <thead class="table-secondary">
                     <tr>
                      <th>#</th>
                      <th>Supplier's Name</th>
                      <th>Material Name</th>
                      <th>Quantity</th>
                      <th>Price</th>
                      <th>Amount</th>
                      <th>Paid</th>
                      <th>Actions</th>
                     </tr>
                   </thead>
                   <tbody id="tableBody">
                      <?php $__currentLoopData = $expenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $expense): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                         <tr>
                            <td>#</td>
                            <td><?php echo e($expense->supplier->name); ?></td>
                            <td><?php echo e($expense->material->name); ?></td>
                            <td><?php echo e($expense->quantity); ?></td>
                            <td><?php echo e($expense->price); ?></td>
                            <td><?php echo e($expense->amount); ?></td>
                            <td><?php echo e($expense->paid); ?></td>
                            <td>
                                    <a class="text-primary" data-bs-toggle="modal" data-bs-target="#updateModal<?php echo e($expense->id); ?>" title="Edit">
                                        <i class="bi bi-pencil-fill"></i>
                                    </a>
                                    <div class="modal fade" id="updateModal<?php echo e($expense->id); ?>" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <form action="update_expenses" method="post" class="modal-content">
                                              <?php echo csrf_field(); ?>
                                                <div class="modal-header border border-0">
                                                    <h5 class="modal-title">Update Expenses</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <input type="hidden" name="update" value="update">
                                                    <input type="hidden" name="id" value="<?php echo e($expense->id); ?>">

                                                    <div class="col-md-12 mb-3">
                                                      <label for="validationDefault01" class="form-label">Supplier name</label>
                                                      <select class="form-control" id="product_list" name="supplier_id">
                                                          <option value="<?php echo e($expense->supplier->id); ?>"><?php echo e($expense->supplier->name); ?></option>
                                                          <?php $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($supplier->id); ?>"><?php echo e($supplier->name); ?></option>
                                                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                      </select>
                                                    </div>

                                                    <div class="col-md-12 mb-3">
                                                      <label for="validationDefault01" class="form-label">Material name</label>
                                                      <select class="form-control" id="product_list" name="material_id">
                                                          <option value="<?php echo e($expense->material->id); ?>"><?php echo e($expense->material->name); ?></option>
                                                          <?php $__currentLoopData = $materials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $material): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($material->id); ?>"><?php echo e($material->name); ?></option>
                                                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                      </select>
                                                    </div>

                                                    <div class="col-md-12 mb-3">
                                                      <label for="validationDefault02" class="form-label">Quantity</label>
                                                      <input type="number" id="quantity" class="form-control" value="<?php echo e($expense->quantity); ?>" required>
                                                    </div>

                                                    <div class="col-md-12 mb-3">
                                                      <label for="validationDefault02" class="form-label">Price</label>
                                                      <input type="number" id="price" class="form-control" value="<?php echo e($expense->price); ?>"   required>
                                                    </div>

                                                    <div class="col-md-12 mb-3">
                                                      <label for="validationDefault02" class="form-label">Amount</label>
                                                      <input type="number" id="amount" class="form-control" value="<?php echo e($expense->amount); ?>"  required>
                                                    </div>

                                                    <div class="col-md-12 mb-3">
                                                      <label for="validationDefault02" class="form-label">Paid</label>
                                                      <input type="number" id="paid" class="form-control"  value="<?php echo e($expense->paid); ?>"  required>
                                                    </div>
                                                   
                                                </div>
                                                <div class="modal-footer border border-0">
                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                                    <button type="submit" class="btn btn-primary">
                                                        Save changes
                                                    </button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>

                                    <a href="delete_expense/<?php echo e($expense->id); ?>" class="text-danger">
                                        <i class="bi bi-trash-fill"></i>
                                    </a>
                            </td>
                         </tr> 
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                   </tbody>
                 </table>
               </div>
             </div>
           </div>

       </main>
       <!--end page main-->
<?php echo $__env->make('footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\factory_v2\resources\views/expenses.blade.php ENDPATH**/ ?>