<?php echo $__env->make('header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Ledger Card</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">Ledger Card</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <div class="row">



          <div class="col-12">
            <div class="card">
              <div class="card-header">
                <h3 class="card-title">
                  Ledger Card
                  <a href="<?php echo e(route('ledger_print', ['id' => $id])); ?>" rel="noopener" target="_blank" class="btn btn-default"><i class="fas fa-print"></i> Print</a>
                  <button class="ms-2 btn btn-info btn-sm"  data-toggle="modal" data-target="#modal">
                      <i class="fa fa-calendar"></i> Search
                  </button>
                </h3>

                        <div class="modal fade" id="modal">
                              <div class="modal-dialog modal-sm">
                                <div class="modal-content">
                                    <div class="modal-header">
                                    <h6 class="modal-title">Search Ledger Record</h6>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                    </div>

                                    <form method="post" action="<?php echo e(route('search_ledger')); ?>" enctype="multipart/form-data">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="product_id" value="<?php echo e($id); ?>">
                                        <div class="modal-body">                                            
                                            <div class="form-group">
                                                <label for="exampleInputEmail1">Start Date</label>
                                                <input type="date" class="form-control" placeholder="Start Date" name="start" required>
                                            </div>

                                            <div class="form-group">
                                                <label for="exampleInputEmail1">End Date</label>
                                                <input type="date" class="form-control" placeholder="Start Date" name="end" required>
                                            </div>
                                        </div>
                                        <div class="modal-footer justify-content-between">
                                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                            <button type="submit" class="btn btn-primary">Save changes</button>
                                        </div>
                                    </form>
                                </div>
                              </div>
                        </div>

                <!-- <div class="card-tools">
                  <div class="input-group input-group-sm" style="width: 150px;">
                    <input type="text" name="table_search" class="form-control float-right" placeholder="Search">

                    <div class="input-group-append">
                      <button type="submit" class="btn btn-default">
                        <i class="fas fa-search"></i>
                      </button>
                    </div>
                  </div>
                </div> -->
              </div>
              <!-- /.card-header -->
              <div class="card-body table-responsive p-0">
                <table class="table table-hover text-nowrap">
                  <thead>
                    <tr>
                      <th>ID</th>
                      <th>Date</th>
                      <th>Received</th>
                      <th>Supplied</th>
                      <th>Balance</th>
                      <th>Action</th>
                    </tr>
                  </thead>
                  <tbody>
                    <?php
                        $count=1;
                    ?>
                    <?php $__currentLoopData = $ledger; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ldg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      
                    <tr>
                        <td><?php echo e($count); ?></td>
                        <td><?php echo e(date('jS F Y',strtotime($ldg->created_at))); ?></td>
                        <td><?php echo e($ldg->received); ?></td>
                        <td><?php echo e($ldg->supplied); ?></td>
                        <td><?php echo e($ldg->balance); ?></td>
                        <td>
                          <button class="btn btn-info btn-sm"  data-toggle="modal" data-target="#modal-sm-<?php echo e($ldg->id); ?>">
                              <i class="fa fa-clipboard"></i> Update
                          </button>
                        </td>
                        <div class="modal fade" id="modal-sm-<?php echo e($ldg->id); ?>">
                              <div class="modal-dialog modal-sm">
                                <div class="modal-content">
                                    <div class="modal-header">
                                    <h6 class="modal-title">Update Ledger Record</h6>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                    </div>

                                    <form method="post" action="<?php echo e(route('update_ledger_record')); ?>" enctype="multipart/form-data">
                                        <?php echo csrf_field(); ?>
                                        <div class="modal-body">
                                            
                                            <input type="hidden" name="id" value="<?php echo e($ldg->id); ?>">                                            
                                            <div class="form-group">
                                                <label for="exampleInputEmail1">Received (Stock In)</label>
                                                <input type="number" class="form-control" placeholder="Stock In" name="received" value="<?php echo e($ldg->received); ?>" required>
                                            </div>

                                            <div class="form-group">
                                                <label for="exampleInputEmail1">Supplied (Stock Out)</label>
                                                <input type="number" class="form-control" placeholder="Stock Out" name="supplied" value="<?php echo e($ldg->supplied); ?>" required>
                                            </div>

                                            <div class="form-group">
                                                <label for="exampleInputEmail1">Balance</label>
                                                <input type="number" class="form-control" placeholder="Balance" name="balance" value="<?php echo e($ldg->balance); ?>" required>
                                            </div>
                                            
                                          
                                        </div>
                                        <!-- /.card-body -->

                                        <div class="modal-footer justify-content-between">
                                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                            <button type="submit" class="btn btn-primary">Save changes</button>
                                        </div>
                                    </form>
                                </div>
                              </div>
                        </div>
                    </tr>
                    <?php
                        $count++;
                    ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    
                  </tbody>
                </table>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
        </div>
        <!-- /.row -->
      </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  <footer class="main-footer">
    <div class="float-right d-none d-sm-block">
      <b>Version</b> 3.2.0
    </div>
    <strong>Copyright &copy; <?php echo e(date('Y')); ?> <a href="">Sonnex</a>.</strong> All rights reserved.
  </footer>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.control-sidebar -->
</div>
<!-- ./wrapper -->

<!-- jQuery -->
<script src="<?php echo e(asset('plugins/jquery/jquery.min.js')); ?>"></script>
<!-- Bootstrap 4 -->
<script src="<?php echo e(asset('plugins/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>
<!-- bs-custom-file-input -->
<script src="<?php echo e(asset('plugins/bs-custom-file-input/bs-custom-file-input.min.js')); ?>"></script>
<!-- AdminLTE App -->
<script src="<?php echo e(asset('dist/js/adminlte.min.js')); ?>"></script>
<!-- AdminLTE for demo purposes -->
<script src="<?php echo e(asset('dist/js/demo.js')); ?>"></script>
<!-- Page specific script -->
<script>
$(function () {
  bsCustomFileInput.init();
});
</script>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\sonnexindustries.com\resources\views/ledger_card.blade.php ENDPATH**/ ?>