<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\UserController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', [UserController::class,'login']);
Route::get('login', [UserController::class,'login'])->name('login');
Route::post('login_user', [UserController::class,'authuser'])->name('login_user');
// Route::get('newuser', [UserController::class,'newuser'])->name('newuser');
// Route::post('add_user', [UserController::class,'add_user'])->name('add_user');
Route::get('dashboard', [UserController::class,'dashboard'])->name('dashboard')->middleware('auth');

Route::get('inventories', [UserController::class,'inventories'])->name('inventories')->middleware('auth');
Route::post('add_inventory', [UserController::class,'add_inventory'])->name('add_inventory');
Route::post('update_inventory', [UserController::class,'update_inventory'])->name('update_inventory');
Route::get('delete_inventory/{id}', [UserController::class,'delete_inventory'])->name('delete_inventory');


Route::get('materials', [UserController::class,'materials'])->name('materials')->middleware('auth');
Route::post('add_material', [UserController::class,'add_material'])->name('add_material');
Route::post('update_material', [UserController::class,'update_material'])->name('update_material');
Route::get('delete_material/{id}', [UserController::class,'delete_material'])->name('delete_material');


Route::get('products', [UserController::class,'products'])->name('products')->middleware('auth');
Route::post('add_product', [UserController::class,'add_product'])->name('add_product');
Route::post('update_product', [UserController::class,'update_product'])->name('update_product');
Route::get('delete_product/{id}', [UserController::class,'delete_product'])->name('delete_product');



Route::get('production', [UserController::class,'production'])->name('production')->middleware('auth');
Route::post('add_production', [UserController::class,'add_production'])->name('add_production');
Route::post('update_production', [UserController::class,'update_production'])->name('update_production');
Route::get('delete_production/{id}', [UserController::class,'delete_production'])->name('delete_production');



Route::get('incidence-report', [UserController::class,'incidence_report'])->name('incidence-report')->middleware('auth');
Route::post('add_report', [UserController::class,'add_report'])->name('add_report');
Route::post('update_report', [UserController::class,'update_report'])->name('update_report');
Route::get('delete_report/{id}', [UserController::class,'delete_report'])->name('delete_report');


Route::get('sales', [UserController::class,'sales'])->name('sales')->middleware('auth');
Route::post('add_sales', [UserController::class,'add_sales'])->name('add_sales');
Route::post('update_sales', [UserController::class,'update_sales'])->name('update_sales');
Route::get('delete_sales/{id}', [UserController::class,'delete_sales'])->name('delete_sales');


Route::get('expenses', [UserController::class,'expenses'])->name('expenses')->middleware('auth');
Route::post('add_expenses', [UserController::class,'add_expenses'])->name('add_expenses');
Route::post('update_expenses', [UserController::class,'update_expenses'])->name('update_expenses');
Route::get('delete_expenses/{id}', [UserController::class,'delete_expenses'])->name('delete_expenses');


Route::get('user-accounts', [UserController::class,'user_accounts'])->name('user-accounts')->middleware('auth');
Route::post('  ount', [UserController::class,'add_useraccount'])->name('add_useraccount');
Route::post('update_useraccount', [UserController::class,'update_useraccount'])->name('update_useraccount');
Route::get('delete_useraccount/{id}', [UserController::class,'delete_useraccount'])->name('delete_useraccount');


Route::get('employees', [UserController::class,'employees'])->name('employees')->middleware('auth');
Route::post('add_employee', [UserController::class,'add_employee'])->name('add_employee');
Route::post('update_employee', [UserController::class,'update_employee'])->name('update_employee');
Route::get('delete_employee/{id}', [UserController::class,'delete_employee'])->name('delete_employee');


Route::get('payroll', [UserController::class,'payroll'])->name('payroll')->middleware('auth');
Route::post('add_payroll', [UserController::class,'add_payroll'])->name('add_payroll');
Route::post('update_payroll', [UserController::class,'update_payroll'])->name('update_payroll');
Route::get('delete_payroll/{id}', [UserController::class,'delete_payroll'])->name('delete_payroll');


Route::get('customers', [UserController::class,'customers'])->name('customers')->middleware('auth');
Route::post('add_customer', [UserController::class,'add_customer'])->name('add_customer');
Route::post('update_customer', [UserController::class,'update_customer'])->name('update_customer');
Route::get('delete_customer/{id}', [UserController::class,'delete_customer'])->name('delete_customer');


Route::get('suppliers', [UserController::class,'suppliers'])->name('suppliers')->middleware('auth');
Route::post('add_supplier', [UserController::class,'add_supplier'])->name('add_supplier');
Route::post('update_supplier', [UserController::class,'update_supplier'])->name('update_supplier');
Route::get('delete_supplier/{id}', [UserController::class,'delete_supplier'])->name('delete_supplier');

Route::get('export-payroll', [UserController::class, 'exportActivePayroll'])->name('export.payroll');




Route::get('settings', [UserController::class,'settings'])->name('settings')->middleware('auth');
Route::post('change_password', [UserController::class,'change_password'])->name('change_password');
Route::get('logout', [UserController::class,'logout'])->name('logout');



