@include('header')

       <!--start content-->
       <main class="page-content">
        <!--breadcrumb-->
        <div class="page-breadcrumb d-none d-sm-flex align-items-center mb-3">
          <div class="breadcrumb-title pe-3">Dashboard</div>
          <div class="ps-3">
            <nav aria-label="breadcrumb">
              <ol class="breadcrumb mb-0 p-0">
                <li class="breadcrumb-item"><a href="javascript:;"><i class="bx bx-home-alt"></i></a>
                </li>
                <li class="breadcrumb-item active" aria-current="page">Payroll</li>
              </ol>
            </nav>
          </div>


          
        </div>
        <!--end breadcrumb-->

           <div class="card">
             <div class="card-body">
               <div class="d-flex align-items-center">
                  <h5 class="mb-0">Payroll</h5>
                   <form class="ms-auto position-relative">
                     <div class="position-absolute top-50 translate-middle-y search-icon px-3"><i class="bi bi-search"></i></div>
                     <input class="form-control ps-5" type="text" placeholder="search">
                   </form>
               </div>
              <form class="ms-auto" id="addForm" action="add_payroll" method="post">
                @csrf
                <div class="btn-group">
                  <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#exampleVerticallycenteredModal">Add to Payroll</button>             
                  <a href="{{ route('export.payroll') }}" class="btn btn-success">Export Payroll to CSV</a>
                  <div class="modal fade" id="exampleVerticallycenteredModal" tabindex="-1" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered">
                      <div class="modal-content">
                        <div class="modal-header border border-0">
                          <h5 class="modal-title">Add Payroll</h5>
                          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">

                          <div class="col-md-12 mb-3">
                            <label for="validationDefault01" class="form-label">Employee name</label>
                            <select class="form-control" id="employee_list" name="employee_id">
                                @foreach($employees as $employee)
                                    <option value="{{$employee->id}}">{{$employee->name}}</option>
                                @endforeach
                            </select>
                          </div>

                          
                          <div class="col-md-12 mb-3">
                            <label for="validationDefault01" class="form-label">Bank Name</label>
                            <input type="text" name="bank_name" class="form-control" value="" required>
                          </div>
                          <div class="col-md-12 mb-3">
                            <label for="validationDefault01" class="form-label">Account Name</label>
                            <input type="text" name="account_name" class="form-control" value="" required>
                          </div>
                          <div class="col-md-12 mb-3">
                            <label for="validationDefault01" class="form-label">Account No</label>
                            <input type="text" name="account_no" class="form-control" value="" required>
                          </div>
                          <div class="col-md-12 mb-3">
                            <label for="validationDefault01" class="form-label">Salary</label>
                            <input type="text" name="salary" class="form-control" value="" required>
                          </div>
                          <div class="col-md-12 mb-3">
                            <label for="validationDefault01" class="form-label">Status</label>
                            <select name="status" id="status" class="form-control">
                              <option>Active</option>
                              <option>In Active</option>
                            </select>
                          </div>
                          
                          

                        </div>
                        <div class="modal-footer border border-0">
                          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                          <button type="submit" data-bs-dismiss="modal" class="btn btn-primary">Save changes</button>
                        </div>
                      </div>
                    </div>
                  </div>
                </div> 
              </form>


               <div class="table-responsive mt-3">
                 <table class="table align-middle">
                   <thead class="table-secondary">
                     <tr>
                      <th>#</th>
                      <th>Name</th>
                      <!-- <th>Phone</th>
                      <th>Position</th> -->
                      <th>Bank Name</th>
                      <th>Account Name</th>
                      <th>Account No</th>
                      <th>Actual Salary</th>
                      <th>Paid Salary</th>
                      <th>Deduction</th>
                      <th>Status</th>
                      <th>Actions</th>
                     </tr>
                   </thead>
                   <tbody id="tableBody">
                      @foreach($payroll as $pay)
                          <tr>
                            <td>#</td>
                            <td>{{$pay->employee->name}}</td>
                            <td>{{$pay->bank_name}}</td>
                            <td>{{$pay->account_name}}</td>
                            <td>{{$pay->account_no}}</td>
                            <td>{{$pay->salary}}</td>
                            <td>{{$pay->paid_salary}}</td>
                            <td>{{$pay->deduction}}</td>
                            <td>{{$pay->status}}</td>
                            <td>
                                    <a class="text-primary" data-bs-toggle="modal" data-bs-target="#updateModal{{$pay->id}}" title="Edit">
                                        <i class="bi bi-pencil-fill"></i>
                                    </a>
                                    <div class="modal fade" id="updateModal{{$pay->id}}" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <form action="update_supplier" class="modal-content" method="post">
                                              @csrf
                                                <div class="modal-header border border-0">
                                                    <h5 class="modal-title">Update Payroll</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <input type="hidden" name="id" value="{{$pay->id}}">

                                                    <div class="col-md-12 mb-3">
                                                      <label for="validationDefault01" class="form-label">Bank Name</label>
                                                      <input type="text" name="bank_name" class="form-control" value="{{$pay->bank_name}}" required>
                                                    </div>
                                                    <div class="col-md-12 mb-3">
                                                      <label for="validationDefault01" class="form-label">Account Name</label>
                                                      <input type="text" name="account_name" class="form-control" value="{{$pay->account_name}}" required>
                                                    </div>
                                                    <div class="col-md-12 mb-3">
                                                      <label for="validationDefault01" class="form-label">Account No</label>
                                                      <input type="text" name="account_no" class="form-control" value="{{$pay->account_no}}" required>
                                                    </div>
                                                    <div class="col-md-12 mb-3">
                                                      <label for="validationDefault01" class="form-label">Salary</label>
                                                      <input type="text" name="salary" class="form-control" value="{{$pay->salary}}" required>
                                                    </div>
                                                    <div class="col-md-12 mb-3">
                                                      <label for="validationDefault01" class="form-label">Status</label>
                                                      <select name="status" id="status" class="form-control">
                                                        <option value="{{$pay->status}}">{{$pay->status}}</option>
                                                        <option>Active</option>
                                                        <option>In Active</option>
                                                      </select>
                                                    </div>
                                                </div>
                                                <div class="modal-footer border border-0">
                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                                    <button type="submit" class="btn btn-primary">
                                                        Save changes
                                                    </button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>

                                    <a href="delete_supplier/{{$pay->id}}" class="text-danger">
                                        <i class="bi bi-trash-fill"></i>
                                    </a>                              
                            </td>
                          </tr>

                     @endforeach
                   </tbody>
                 </table>

               </div>
             </div>
           </div>

       </main>
       <!--end page main-->
@include('footer')