<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\View\View;
use App\Models\Customer;
use App\Models\User;
use App\Models\Inventory;
use App\Models\Material;

use Illuminate\Support\Facades\DB;

use App\Models\Production;
use App\Models\Incidence_Report;
use App\Models\Expense;
use App\Models\Sale;
use App\Models\Employee;
use App\Models\Supplier;
use App\Models\Referee;
use App\Models\Payroll;
use App\Models\Product;


use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;

use Illuminate\Support\Carbon;

use App\Mail\SigninMail;
use Illuminate\Support\Str;
use Symfony\Component\HttpFoundation\StreamedResponse;
class UserController extends Controller
{
    public function login(){

        return view('login');
    }

    public function authuser(Request $request){
        // Validate incoming data
        $request->validate([
            'stud_no' => 'required',
            'password' => 'required'
        ]);

        // Attempt to find parent by phone number
        $student = Student::where('stud_no', $request->stud_no)->first();

        // Check if parent exists and password is correct
        if ($student && Hash::check($request->password, $student->password)) {
            
            // Put parent data in session
            session([
                'student_logged_in' => true,
                'student_id' => $student->id,
                'firstname' => $student->fullname,
                'lastname' => $student->email,
                'gender' => $student->gender,
                'dob' => $student->dob
            ]);

            return redirect('dashboard'); // Use route name if available
        }

        // Authentication failed
        return back()->with('error', 'Invalid Student ID or password.');
    }

    public function dashboard(){
        $id = session('student_id');


        $student = Student::find($id);
        $nursery_result = DB::table('nursery_result')->where('student_id',$id)->get();
        $primary_result = DB::table('primary_result')->where('student_id',$id)->get();
        $jss_result = DB::table('juniorsecondary_result')->where('student_id',$id)->get();
        $ss_result = DB::table('seniorsecondary_result')->where('student_id',$id)->get();
        return view('dashboard');   
    }

    

    public function inventories(){
        $inventories = Inventory::all();
        $products = Product::all();
        return view('inventory',compact('inventories','products'));

    }

    public function add_inventory(Request $request){
        if(Inventory::where('product_id',$request->product_id)->exists()){
            $inventory = Inventory::where('product_id',$request->product_id)->first();
            $inventory->quantity += $request->quantity;
            if($inventory->save()){
                return redirect()->back()->with('message','Inventory has been updated');
            }
        }else{
            $inventory = new Inventory;
            $inventory->product_id =  $request->product_id;
            $inventory->quantity = $request->quantity;
            if($inventory->save()){
                return redirect()->back()->with('message','New Inventory has been added');
            }
        }
        
    }

    public function update_inventory(Request $request){
        $inventory = Inventory::find($request->id);
        $inventory->product_id = $request->product_id;
        $inventory->quantity = $request->quantity;
        if($inventory->save()){
            return back();
        }    
    }

    public function delete_inventory($id){
        $inventory = Inventory::find($id);
        $inventory->delete();
        return back();
    }

    public function materials(){
        $materials = Material::all();
        return view('materials',compact('materials'));
    }

    public function add_material(Request $request){
        $material = new Material;
        $material->name =  $request->name;
        $material->quantity = $request->quantity;
        if($material->save()){
            return redirect()->back()->with('message','Material has been added');
        }
    }

    public function update_material(Request $request){
        $material = Material::find($request->id);
        $material->name =  $request->name;
        $material->quantity = $request->quantity;
        if($material->save()){
            return back();
        }    
    }

    public function delete_material($id){
        $material = Material::find($id);
        $material->delete();
        return back();
    }




    public function products(){
        $products = Product::all();
        return view('products',compact('products'));
    }

    public function add_product(Request $request){
        $product = new Product;
        $product->name =  $request->name;
        $product->price = $request->price;
        if($product->save()){
            return back();
        }
    }

    public function update_product(Request $request){
        $product = Product::find($request->id);
        $product->name =  $request->name;
        $product->price = $request->price;
        if($product->save()){
            return back();
        }    
    }

    public function delete_product($id){
        $product = Product::find($id);
        $product->delete();
        return back();
    }



    public function production(){
        $productions = Production::all();
        $products = Product::all();
        $materials = Material::all();
        return view('production',compact('productions','products','materials'));
    }

    public function add_production(Request $request){
        $production = new Production;
        $logNumber = 'PROD-' . strtoupper(Str::random(8));
        $production->log =  $logNumber;
        $production->description =  $request->description;
        $production->product_id = $request->product_id;
        $production->material_id = $request->material_id;
        $production->input_tonnage = $request->input_tonnage;
        $production->output_tonnage = $request->output_tonnage;


        if($production->save()){
            return back();
        }
    }

    public function update_production(Request $request){
        $production = Production::find($request->id);
        $production->description =  $request->description;
        $production->product_id = $request->product_id;
        $production->material_id = $request->material_id;
        $production->input_tonnage = $request->input_tonnage;
        $production->output_tonnage = $request->output_tonnage;


        if($production->save()){
            return back();
        }   
    }

    public function delete_production($id){
        $production = Production::find($id);
        $production->delete();
        return back();
    }


    public function incidence_report(){
        $reports = Incidence_Report::all();
        $productions = Production::all();
        return view('incidence_report',compact('reports','productions'));
    }

    public function add_report(Request $request){
        $report = new Incidence_Report;
        $report->production_id = $request->production_id;
        $report->description = $request->description;
        if($report->save()){
            return back();
        }
    }

    public function update_report(Request $request){
        $report = Incidence_Report::find($request->id);
        $report->production_id = $request->production_id;
        $report->description = $request->description;


        if($report->save()){
            return back();
        }   
    }

    public function delete_report($id){
        $report = Incidence_Report::find($id);
        $report->delete();
        return back();
    }



    public function sales(){
        $sales = Sale::all();
        $customers = Customer::all();
        $products = Product::all();
        return view('sales',compact('sales','customers','products'));
    }

    public function add_sales(Request $request){
        $sale = new Sale;
        $sale->customer_id = $request->customer;
        $json = $request->input('product');
        $products = json_decode($json, true);
        $sale->products = $products;
        $sale->amount = $request->amount;
        $sale->paid = $request->paid;
        $sale->balance = $request->balance;
        if($sale->save()){
            return back();
        }
    }

    public function update_sales(Request $request){
        $report = Sale::find($request->id);
        $report->product_id = $request->product_id;
        $report->description = $request->description;


        if($report->save()){
            return back();
        }   
    }

    public function delete_sales($id){
        $report = Sales::find($id);
        $report->delete();
        return back();
    }


    public function expenses(){
        $expenses = Expense::all();
        $suppliers = Supplier::all();
        $materials = Material::all();
        return view('expenses',compact('expenses','suppliers','materials'));
    }

    public function add_expenses(Request $request){
        $expense = new Expense;
        $expense->supplier_id = $request->supplier_id;
        $expense->material_id = $request->material_id;
        $expense->quantity = $request->quantity;
        $expense->amount = $request->amount;
        $expense->price = $request->price;
        $expense->paid = $request->paid;
        $expense->balance = $request->balance;
        if($report->save()){
            return back();
        }
    }

    public function update_expenses(Request $request){
        $expense = Expense::find($request->id);
        $expense->supplier_id = $request->supplier_id;
        $expense->material_id = $request->material_id;
        $expense->quantity = $request->quantity;
        $expense->amount = $request->amount;
        $expense->price = $request->price;
        $expense->paid = $request->paid;
        $expense->balance = $request->balance;
        if($report->save()){
            return back();
        }   
    }

    public function delete_expenses($id){
        $expense = Expense::find($id);
        $expense->delete();
        return back();
    }






    public function user_accounts():View{
        $users = User::all();
        return view('users',compact('users'));
    }

    public function add_useraccount(Request $request){
        $user = new User;
        $user->name = $request->new_name;
        // $user->phone = $request->phone;
        $user->email = $request->new_email;
        $user->username = $request->new_username;
        $user->super_admin = $request->new_superadmin;
        $user->password = Hash::make($request->password);
        $user->sales = $request->new_sales;
        $user->accounts = $request->new_accounts;
        $user->production = $request->new_production;
        $user->stocks = $request->new_stocks;
        $user->status = 1;
        // $user->address = $request->new_address;
        // $user->position = $request->new_position;
        // $user->referees = $request->new_referees;
        // $user->photo = $request->new_photo;
        // // $user->data_employed = $request->new_date_employed;
        $user->save();
        return back()->with('message','user added');
    }

    public function update_useraccount(Request $request){
        $user = User::find($request->id);
        $user->name = $request->name;
        // $user->phone = $request->phone;
        $user->email = $request->email;
        $user->username = $request->username;
        $user->super_admin = $request->super_admin;
        $user->sales = $request->sales;
        $user->accounts = $request->accounts;
        $user->production = $request->production;
        $user->stocks = $request->stock;
        // $user->status = $request->staus;
        // $user->address = $request->address;
        // $user->position = $request->position;
        // $user->referees = $request->referees;
        // $user->photo = $request->photo;
        // $user->data_employed = $request->date_employed;
        $user->save();
        return back()->with('message','user added');
    }

    public function delete_useraccount($id){
        $expense = Expense::find($id);
        $expense->delete();
        return back();
    }



    public function employees():View{
        $employees = Employee::all();
        return view('employees',compact('employees'));
    }

    public function add_employee(Request $request){
        $employee = new Employee;
        $employee->name = $request->name;
        $employee->phone = $request->phone;
        $employee->address = $request->address;
        $employee->position = $request->position;
        $employee->referee = $request->referee;

        $employee->salary = $request->salary;
        $employee->deduction = $request->deduction;
        $employee->paid_salary = $request->paid_salary;
        $employee->status = $request->status;
        $employee->date_employed = $request->date_employed;


        // $employee->photo = $request->photo;

        if ($request->hasFile('photo')) {
            $name = time().'.'.$request->file('photo')->getClientOriginalName();
            $request->file('photo')->move(public_path('photo'), $name); 
            $employee->photo = $name;
        }

        if ($employee->save()) {
            $employee = Employee::latest()->first();
            // $referee = new Referee;
            // $referee->fullname = $request->rname;
            // $referee->relationship = $request->relationship;
            // $referee->company = $request->company;
            // $referee->title = $request->title;
            // $referee->remail = $request->remail;
            // $referee->rphone = $request->rphone;
            // $referee->relationship = $request->relationship;

            $records = [
                [
                    'employee_id' => $employee->id,
                    'fullname' => $request->rname,
                    'relationship' => $request->relationship,
                    'company' => $request->company,
                    'title' => $request->title,
                    'email' => $request->remail,
                    'phone' => $request->rphone,
                    // ... other columns
                ],
                [
                    'employee_id' => $employee->id,
                    'fullname' => $request->rname2,
                    'relationship' => $request->relationship2,
                    'company' => $request->company2,
                    'title' => $request->title2,
                    'email' => $request->remail2,
                    'phone' => $request->rphone2,
                    // ... other columns
                ],
            ];
            Referee::insert($records);



        }

        return back()->with('message','user added');
    }

    public function update_employee(Request $request){
        $employee = Employee::find($request->id);
        $employee->name = $request->name;
        $employee->phone = $request->phone;
        $employee->address = $request->address;
        $employee->position = $request->position;
        $employee->referee = $request->referee;
        // $employee->photo = $request->photo;
        $employee->salary = $request->salary;
        $employee->deduction = $request->deduction;
        $employee->paid_salary = $request->paid_salary;
        $employee->status = $request->status;
        $employee->date_employed = $request->date_employed;
        $employee->save();
        return back()->with('message','user added');
    }

    public function delete_employee($id){
        $employee = Employee::find($id);
        $employee->delete();
        return back();
    }


    public function payroll():View{
        $payroll = Payroll::all();
        $employees = Employee::all();
        return view('payroll',compact('employees','payroll'));
    }

    public function exportActivePayroll(){
    // Fetch active payroll records
    $payrolls = DB::table('payroll')
        ->select('account_name', 'account_no', 'paid_salary', 'bank_name')
        ->where('status', 'LIKE', 'Active')
        ->get();

    // Check if there’s data
    if ($payrolls->isEmpty()) {
        return back()->with('error', 'No data found for the specified selection.');
    }

    // Create a streamed response for CSV export
    $response = new StreamedResponse(function () use ($payrolls) {
        $handle = fopen('php://output', 'w');

        // Column headers
        fputcsv($handle, ['Account Name', 'Account Number', 'Paid Salary', 'Bank Name']);

        // Write data rows
        foreach ($payrolls as $payroll) {
            fputcsv($handle, [
                $payroll->account_name,
                $payroll->account_no,
                $payroll->paid_salary,
                $payroll->bank_name
            ]);
        }

        fclose($handle);
    });

    // Define response headers
    $response->headers->set('Content-Type', 'text/csv');
    $response->headers->set('Content-Disposition', 'attachment; filename="selected_data.csv"');

    return $response;
}

    public function add_payroll(Request $request){
        $payroll = new Payroll;
        $payroll->employee_id = $request->employee_id;
        $payroll->bank_name = $request->bank_name;
        $payroll->account_name = $request->account_name;
        $payroll->account_no = $request->account_no;
        $payroll->salary = $request->salary;
        $payroll->paid_salary = $request->salary;
        $payroll->deduction = 0;
        $payroll->status = $request->status;

        $payroll->save();
        return back()->with('message','user added');
    }

    public function update_payroll(Request $request){
        $payroll = Payroll::find($request->id);
        $payroll->employee_id = $request->employee_id;
        $payroll->bank_name = $request->bank_name;
        $payroll->account_name = $request->account_name;
        $payroll->account_no = $request->account_no;
        $payroll->salary = $request->salary;
        $payroll->paid_salary = $request->paid_salary;
        $payroll->deduction = $request->deduction;
        $payroll->status = $request->status;
        $payroll->save();
        return back()->with('message','user added');
    }

    public function delete_payroll($id){
        $payroll = Payroll::find($id);
        $payroll->delete();
        return back();
    }


    public function suppliers():View{
        $suppliers = Supplier::all();
        return view('suppliers',compact('suppliers'));
    }

    public function add_supplier(Request $request){
        $supplier = new Supplier;
        $supplier->name = $request->name;
        $supplier->address = $request->address;
        $supplier->phone = $request->phone;
        $supplier->email = $request->email;


        $supplier->save();
        return back()->with('message','user added');
    }

    public function update_supplier(Request $request){
        $supplier = Supplier::find($request->id);

        $supplier->name = $request->name;
        $supplier->address = $request->address;
        $supplier->phone = $request->phone;
        $supplier->email = $request->email;

        $supplier->save();
        return back()->with('message','user added');
    }

    public function delete_supplier($id){
        $supplier = Supplier::find($id);
        $supplier->delete();
        return back();
    }



    public function customers():View{
        $customers = Customer::all();
        return view('customers',compact('customers'));
    }

    public function add_customer(Request $request){
        $customer = new Customer;
        $customer->name = $request->name;
        $customer->phone = $request->phone;
        $customer->address = $request->address;
        $customer->email = $request->email;

        if ($customer->save()) {
            return back()->with('message','New Customer has been added!!');
        }else{
            return back()->with('message','Failed!!');
        }

    }

    public function update_customer(Request $request){
        $customer = Customer::find($request->id);
        $customer->name = $request->name;
        $customer->phone = $request->phone;
        $customer->address = $request->address;
        $customer->email = $request->email;

        if ($customer->save()) {
            return back()->with('message','New Customer has been updated!!');
        }else{
            return back()->with('message','Failed!!');
        }

    }

     public function delete_customer($id){
        $customer = Customer::find($id);
        $customer->delete();
        return back();
    }

    
    public function settings():View{
        return view('settings');
    }

    public function change_password(Request $request){
        $id = Auth::user()->id;
        $email = Auth::user()->email; 
        $cpass = $request->input('cpass') ;
        $npass = $request->input('npass') ;
        $vpass = $request->input('vpass') ;

        if(Hash::check($cpass,Auth::user()->password)){
            if($npass == $vpass){
                User::where('id', $id)
               ->update(['password' => Hash::make($npass)]);
               
                $message = "Password has been Updated!";
                return back()->with('message',$message);
           }else{
            $message = "Passwords are not the same!";
            return back()->with('message',$message);
           }
        }else{
            $message = "Please Enter the Current Password!";
            return back()->with('message',$message);
        }

    }

    public function logout(Request $request){
        Auth::logout();
        $request->session()->invalidate();
        $request->session()->regenerateToken();
        return redirect('login');
    }


}


